package pogamutjavabot080430;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PickedItemsUpMemory extends Object
{
    public static long DefaultForgetTwice = 60;
    public static long DefaultForgetTime = 27;
    public static long DeafultForgetTimeHalf = 13;
    
    private long forgetTwice;
    private long forgetTime;
    private long forgetTimeHalf;
     
    private Map<Integer, Long> items = new HashMap<Integer, Long>();
        
    PickedItemsUpMemory()
    {
        forgetTwice = DefaultForgetTwice * 1000;
        forgetTime = DefaultForgetTime * 1000;
        forgetTimeHalf = DeafultForgetTimeHalf * 1000;
    }
    
    PickedItemsUpMemory(long forgetTwice, long forgetTime, long forgetTimeHalf)
    {
        this.forgetTwice = forgetTwice * 1000;
        this.forgetTime = forgetTime * 1000;
        this.forgetTimeHalf = forgetTimeHalf * 1000;
    }
    
    private void add(int itemId, long time)
    {
        Long itemTime = items.get(itemId);
        if (itemTime != null)
           
            itemTime = Math.max(itemTime, time);
        else
            items.put(itemId, time);
    }
    
    public void addTwice(int ItemID)
    {       
        add(ItemID, System.currentTimeMillis() + forgetTwice);
    }
    
    public void addFull(int ItemID)
    {       
        add(ItemID, System.currentTimeMillis() + forgetTime);
    }
    
    public void addHalf(int ItemID)
    {
        add(ItemID, System.currentTimeMillis() + forgetTimeHalf);
    }
    
    public Long remove(int ItemID)
    {
        return items.remove(ItemID);
    }
    
    public boolean contains(int itemID)
    {
        return items.containsKey(itemID);
    }
    
    public void doForgetItems()
    {
        Iterator<Long> iter = items.values().iterator();
        while(iter.hasNext()) 
        {
            long time = iter.next();
            if (time <= System.currentTimeMillis())
                iter.remove();
        }        
    }
    
    public int size()
    {
        return items.size();
    }
}